<?php
require_once '../config/database.php';

function getMetaValue($pdo, $metaKey, $tables) {
    $stmt = $pdo->prepare("SELECT meta_value FROM {$tables['metadata']} WHERE meta_key = ?");
    $stmt->execute([$metaKey]);
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    return $result ? $result['meta_value'] : '0';
}

$dashboardData = [
    'app_opens' => getMetaValue($pdo, 'App Open', $tables),
    'boycotts' => getMetaValue($pdo, 'Totol Boycott Time', $tables),
    'admin_username' => getMetaValue($pdo, 'AdminUsername', $tables),
    'ldut' => getMetaValue($pdo, 'LDUT', $tables)
];

header('Content-Type: application/json');
echo json_encode($dashboardData);
?> 