<?php

// --- Database Configuration ---
$host = "localhost";
$dbName = "digitalb_beaccurate";
$userName = "digitalb_beaccurate";
$pass = "Saiful.1633"; // WARNING: Hardcoding passwords is insecure. Consider environment variables or config files.
$tableName = "MetaData";

// --- Target Key ---
// CHANGED: Updated the target key to "App Open"
$targetMetaKey = "App Open";

// --- Set Header for JSON Output ---
header('Content-Type: application/json');

// --- Initialize Response Array ---
$response = [];

// --- Create Connection ---
$conn = mysqli_connect($host, $userName, $pass, $dbName);

// --- Check Connection ---
if (!$conn) {
    // Send JSON error response
    http_response_code(500); // Internal Server Error
    $response['status'] = 'error';
    $response['message'] = 'Database connection failed: ' . mysqli_connect_error();
    echo json_encode($response);
    exit; // Stop script execution
}

// --- Prepare SQL Statement (using prepared statements for security) ---
// Use backticks (`) around table and column names if they contain spaces or are reserved keywords (optional here but good practice)
$sql = "SELECT `meta_value` FROM `" . $tableName . "` WHERE `meta_key` = ? LIMIT 1";

$stmt = mysqli_prepare($conn, $sql);

if (!$stmt) {
    // Send JSON error response
    http_response_code(500);
    $response['status'] = 'error';
    $response['message'] = 'Error preparing statement: ' . mysqli_error($conn);
    mysqli_close($conn); // Close connection before exiting
    echo json_encode($response);
    exit;
}

// --- Bind Parameters ---
// "s" means the parameter is a string
mysqli_stmt_bind_param($stmt, "s", $targetMetaKey);

// --- Execute Statement ---
if (!mysqli_stmt_execute($stmt)) {
    // Send JSON error response
    http_response_code(500);
    $response['status'] = 'error';
    $response['message'] = 'Error executing statement: ' . mysqli_stmt_error($stmt);
    mysqli_stmt_close($stmt); // Close statement
    mysqli_close($conn);      // Close connection
    echo json_encode($response);
    exit;
}

// --- Get Result ---
$result = mysqli_stmt_get_result($stmt);

// --- Fetch Data ---
if ($result && mysqli_num_rows($result) > 0) {
    $row = mysqli_fetch_assoc($result);
    $metaValue = $row['meta_value'];

    $response['status'] = 'success';
    $response['data'] = [
        'meta_key' => $targetMetaKey, // Will now show "App Open"
        'meta_value' => $metaValue
    ];
     // Optionally decode if the stored value itself is JSON
     // $decodedValue = json_decode($metaValue);
     // if (json_last_error() === JSON_ERROR_NONE) {
     //    $response['data']['meta_value'] = $decodedValue;
     // } else {
     //    $response['data']['meta_value'] = $metaValue; // Keep as string if not valid JSON
     // }

} else {
    // Key not found
    http_response_code(404); // Not Found
    $response['status'] = 'not_found';
    // The error message will now correctly mention "App Open" if it's not found
    $response['message'] = "Meta key '" . htmlspecialchars($targetMetaKey) . "' not found in table '" . htmlspecialchars($tableName) . "'.";
}

// --- Output JSON Response ---
// JSON_PRETTY_PRINT makes the output more readable (optional)
echo json_encode($response, JSON_PRETTY_PRINT);

// --- Close Statement and Connection ---
mysqli_stmt_close($stmt);
mysqli_close($conn);

?>