<?php
require_once '../config/database.php';

header('Content-Type: application/json');

try {
    // Fetch all categories and subcategories
    $stmt = $pdo->query("SELECT DISTINCT Category FROM {$tables['categories']} ORDER BY Category");
    $categories = $stmt->fetchAll(PDO::FETCH_COLUMN);

    // Fetch all subcategories grouped by category
    $stmt = $pdo->query("SELECT Category, SubCategory FROM {$tables['categories']} ORDER BY Category, SubCategory");
    $subcategories = [];
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        if (!isset($subcategories[$row['Category']])) {
            $subcategories[$row['Category']] = [];
        }
        $subcategories[$row['Category']][] = $row['SubCategory'];
    }

    echo json_encode([
        'success' => true,
        'categories' => $categories,
        'subcategories' => $subcategories
    ]);
} catch(Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?> 