<?php
require_once 'config/database.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Request a Product - BeAccurate</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="css/style.css">
    <style>
        body {
            background-color: #f5f5f5;
            font-family: 'Inter', sans-serif;
            margin: 0;
            padding: 0;
        }

        .container {
            max-width: 800px;
            margin: 2rem auto;
            padding: 2rem;
            background: white;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
        }

        .header {
            text-align: center;
            margin-bottom: 2rem;
        }

        .header h1 {
            color: #333;
            margin-bottom: 0.5rem;
        }

        .header p {
            color: #666;
            margin: 0;
        }

        .request-form {
            display: grid;
            gap: 1.5rem;
        }

        .form-group {
            margin-bottom: 1rem;
        }

        .form-group label {
            display: block;
            margin-bottom: 0.5rem;
            font-weight: 500;
            color: #333;
        }

        .form-group input,
        .form-group select,
        .form-group textarea {
            width: 100%;
            padding: 0.75rem;
            border: 1px solid #ddd;
            border-radius: 4px;
            font-size: 1rem;
            font-family: inherit;
        }

        .form-group textarea {
            min-height: 100px;
            resize: vertical;
        }

        .image-input-toggle {
            display: flex;
            gap: 1rem;
            margin-bottom: 1rem;
        }

        .image-input-toggle label {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            cursor: pointer;
        }

        .submit-btn {
            background-color: #007bff;
            color: white;
            border: none;
            padding: 1rem;
            border-radius: 4px;
            font-size: 1rem;
            cursor: pointer;
            transition: background-color 0.2s;
        }

        .submit-btn:hover {
            background-color: #0056b3;
        }

        .success-message {
            background-color: #d4edda;
            color: #155724;
            padding: 1rem;
            border-radius: 4px;
            margin-bottom: 1rem;
            display: none;
        }

        .error-message {
            background-color: #f8d7da;
            color: #721c24;
            padding: 1rem;
            border-radius: 4px;
            margin-bottom: 1rem;
            display: none;
        }

        .loading {
            display: none;
            text-align: center;
            margin: 1rem 0;
        }

        .loading i {
            animation: spin 1s linear infinite;
        }

        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1><i class="fas fa-box-open"></i> Request a Product</h1>
            <p>Help us improve our database by suggesting new products</p>
        </div>

        <div class="success-message" id="success-message">
            <i class="fas fa-check-circle"></i> Your request has been submitted successfully!
        </div>

        <div class="error-message" id="error-message"></div>

        <form id="request-form" class="request-form">
            <div class="form-group">
                <label for="productName">Product Name *</label>
                <input type="text" id="productName" name="product_name" required>
            </div>

            <div class="form-group">
                <label for="productBrand">Brand *</label>
                <input type="text" id="productBrand" name="product_brand" required>
            </div>

            <div class="form-group">
                <label for="productCategory">Category *</label>
                <select id="productCategory" name="product_category" required>
                    <option value="">Select Category</option>
                </select>
            </div>

            <div class="form-group">
                <label for="productSubCategory">Sub Category</label>
                <select id="productSubCategory" name="sub_category">
                    <option value="">Select Sub Category</option>
                </select>
            </div>

            <div class="form-group">
                <label for="barcode">Barcode (Optional)</label>
                <input type="text" id="barcode" name="barcode">
            </div>

            <div class="form-group">
                <label>Product Image</label>
                <div class="image-input-toggle">
                    <label>
                        <input type="radio" name="imageType" value="upload" checked>
                        Upload Image
                    </label>
                    <label>
                        <input type="radio" name="imageType" value="url">
                        Image URL
                    </label>
                </div>
                <input type="file" id="productImage" name="product_image" accept="image/*">
                <input type="url" id="productImageUrl" name="product_image_url" placeholder="https://..." style="display: none;">
            </div>

            <div class="form-group">
                <label for="moreInfo">Additional Information</label>
                <textarea id="moreInfo" name="more_info" placeholder="Any additional details about the product..."></textarea>
            </div>

            <div class="loading" id="loading">
                <i class="fas fa-spinner"></i> Submitting request...
            </div>

            <button type="submit" class="submit-btn">
                <i class="fas fa-paper-plane"></i> Submit Request
            </button>
        </form>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const form = document.getElementById('request-form');
            const successMessage = document.getElementById('success-message');
            const errorMessage = document.getElementById('error-message');
            const loading = document.getElementById('loading');
            const categorySelect = document.getElementById('productCategory');
            const subcategorySelect = document.getElementById('productSubCategory');
            const imageTypeRadios = document.querySelectorAll('input[name="imageType"]');
            const productImage = document.getElementById('productImage');
            const productImageUrl = document.getElementById('productImageUrl');

            // Load categories
            fetch('src/get_categories.php')
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        data.categories.forEach(category => {
                            const option = document.createElement('option');
                            option.value = category;
                            option.textContent = category;
                            categorySelect.appendChild(option);
                        });

                        // Store subcategories data
                        window.subcategoriesData = data.subcategories;
                    }
                })
                .catch(error => {
                    console.error('Error loading categories:', error);
                    showError('Error loading categories. Please try again later.');
                });

            // Update subcategories when category changes
            categorySelect.addEventListener('change', function() {
                const category = this.value;
                subcategorySelect.innerHTML = '<option value="">Select Sub Category</option>';
                
                if (category && window.subcategoriesData && window.subcategoriesData[category]) {
                    window.subcategoriesData[category].forEach(subcategory => {
                        const option = document.createElement('option');
                        option.value = subcategory;
                        option.textContent = subcategory;
                        subcategorySelect.appendChild(option);
                    });
                }
            });

            // Handle image type toggle
            imageTypeRadios.forEach(radio => {
                radio.addEventListener('change', function() {
                    if (this.value === 'url') {
                        productImage.style.display = 'none';
                        productImageUrl.style.display = 'block';
                    } else {
                        productImage.style.display = 'block';
                        productImageUrl.style.display = 'none';
                    }
                });
            });

            // Form submission
            form.addEventListener('submit', async function(e) {
                e.preventDefault();
                
                // Show loading
                loading.style.display = 'block';
                errorMessage.style.display = 'none';
                successMessage.style.display = 'none';

                const formData = new FormData(form);
                
                try {
                    const response = await fetch('src/submit_product_request.php', {
                        method: 'POST',
                        body: formData
                    });

                    const data = await response.json();

                    if (data.success) {
                        form.reset();
                        successMessage.style.display = 'block';
                        window.scrollTo({ top: 0, behavior: 'smooth' });
                    } else {
                        showError(data.message || 'An error occurred while submitting your request.');
                    }
                } catch (error) {
                    console.error('Error:', error);
                    showError('An error occurred while submitting your request. Please try again later.');
                } finally {
                    loading.style.display = 'none';
                }
            });

            function showError(message) {
                errorMessage.textContent = message;
                errorMessage.style.display = 'block';
                window.scrollTo({ top: 0, behavior: 'smooth' });
            }
        });
    </script>
</body>
</html> 