// js/helpers.js

/**
 * HTML স্পেশাল ক্যারেক্টার এস্কেপ করে।
 * @param {string} str - এস্কেপ করার জন্য স্ট্রিং।
 * @returns {string} এস্কেপ করা স্ট্রিং।
 */
export function escapeHTML(str) {
    if (str === null || str === undefined) {
        return '';
    }
    const div = document.createElement('div');
    div.appendChild(document.createTextNode(String(str))); // নিশ্চিত করুন এটি একটি স্ট্রিং
    return div.innerHTML;
}

/**
 * ইমেজ URL/Base64 ডেটা ফরম্যাট করে ডিসপ্লে করার জন্য।
 * @param {string} base64OrUrl - Base64 স্ট্রিং বা ইমেজ URL।
 * @returns {string} ডিসপ্লে করার জন্য সঠিক src অ্যাট্রিবিউট।
 */
export function formatImageUrlForDisplay(base64OrUrl) {
    if (!base64OrUrl || base64OrUrl === 'none') {
        // কোনো ইমেজ না থাকলে একটি ডিফল্ট প্লেসহোল্ডার ইমেজ রিটার্ন করুন
        // URL টি আপনার সার্ভারে 48x48 পিক্সেলের ডিফল্ট ছবির পাথ হতে পারে
        return 'https://api.accurate.com.bd/48x48.jpg'; // আপনার ডিফল্ট ইমেজ URL
    }
    if (base64OrUrl.startsWith('http://') || base64OrUrl.startsWith('https://') || base64OrUrl.startsWith('data:image')) {
        return base64OrUrl; // এটি সম্ভবত একটি বৈধ URL বা Data URL
    }
    // যদি শুধু Base64 স্ট্রিং হয় (data:image/...;base64, prefix ছাড়া)
    // স্ট্যান্ডার্ড jpeg MIME টাইপ যোগ করে Data URL তৈরি করুন।
    // মনে রাখবেন, backend এ ইমেজ প্রসেসিং logic নিশ্চিত করে যে ডেটা একটি ইমেজ ছিল।
    return 'data:image/jpeg;base64,' + base64OrUrl;
}

/**
 * ফাইল থেকে Base64 ডেটা তৈরি করে।
 * @param {File} file - ইনপুট ফাইল অবজেক্ট।
 * @returns {Promise<string>} Data URL (Base64) সহ প্রমিজ।
 */
export function fileToBase64(file) {
    return new Promise((resolve, reject) => {
        const reader = new FileReader();
        reader.onload = (e) => resolve(e.target.result);
        reader.onerror = (e) => reject(e);
        reader.readAsDataURL(file);
    });
}

// প্রয়োজন অনুযায়ী অন্যান্য হেল্পার ফাংশন এখানে যোগ করা যেতে পারে