    <?php
    // index.php
    // This file primarily serves the HTML structure.
    // Frontend JavaScript will handle authentication and content display dynamically.
    // Session might be started here if needed before any output, but JS handles auth check.
    // It's safer to let backend.php handle sessions.

    // Check if session is already started in includes/auth.php when backend.php is called via fetch.
    // For the initial page load, session_start() *might* be needed here if any PHP logic
    // rendered *in* this file depended on session (e.g., displaying username).
    // However, since all content is loaded via JS fetch after page load,
    // starting session here is not strictly necessary for *this* setup.
    // If you add PHP logic that needs session state directly in index.php, uncomment below.
    // if (session_status() == PHP_SESSION_NONE) {
    //     session_start();
    // }
    ?>
    <!DOCTYPE html>
    <html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Admin Dashboard - Product Management</title>
        <!-- Tailwind CSS CDN -->
        <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
        <!-- Custom CSS -->
        <link rel="stylesheet" href="css/style.css">
    </head>
    <body class="bg-gray-100 font-sans leading-normal tracking-normal">

        <!-- Login Container -->
        <div id="login-container" class="">
            <h1 class="text-2xl font-bold mb-6 text-center text-gray-800">Admin Login</h1>
            <form id="loginForm">
                <div class="mb-4">
                    <label class="block text-gray-700 text-sm font-bold mb-2" for="username">
                        Username:
                    </label>
                    <input class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" id="username" name="username" type="text" placeholder="Username" required>
                </div>
                <div class="mb-6">
                    <label class="block text-gray-700 text-sm font-bold mb-2" for="password">
                        Password:
                    </label>
                    <input class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 mb-3 leading-tight focus:outline-none focus:shadow-outline" id="password" name="password" type="password" placeholder="******************" required>
                </div>
                <div class="flex items-center justify-between">
                    <button id="loginBtn" class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded focus:outline-none focus:shadow-outline w-full action-button" type="submit">
                        Sign In
                         <span id="loginSpinner" class="spinner hidden"></span>
                    </button>
                </div>
                <p id="loginMessage" class="form-message error"></p>
            </form>
        </div>


        <!-- Dashboard Container -->
        <div id="dashboard-container" class="container mx-auto mt-8 px-4 hidden">
            <div class="flex flex-col sm:flex-row justify-between items-center mb-6 gap-4">
                <h1 class="text-2xl font-bold text-gray-800 text-center sm:text-left">Product Requests</h1>
                 <div class="flex flex-col sm:flex-row space-y-2 sm:space-y-0 sm:space-x-4 w-full sm:w-auto">
                     <button id="addProductBtn" class="add-button action-button w-full sm:w-auto">
                          + Add New Product Directly
                      </button>
                      <button id="logoutBtn" class="logout-button action-button w-full sm:w-auto">
                         Logout
                         <span id="logoutSpinner" class="spinner hidden"></span>
                      </button>
                 </div>
            </div>

            <div id="requests-list" class="">
                <!-- Product request list items will be loaded here by script.js -->
            </div>
             <p id="loading-text" class="text-center text-gray-600 mt-8 py-4">Loading product requests...</p>
             <p id="no-requests" class="text-center text-gray-600 mt-8 py-4 hidden">No product requests found.</p>
        </div>

        <!-- The Review Modal -->
        <div id="reviewModal" class="modal">
            <!-- Modal content -->
            <div class="modal-content">
                <span class="close-button close-review-modal">×</span>
                <h2 class="text-2xl font-bold mb-6 text-gray-800">Review & Edit Product Request</h2>

                <form id="reviewForm">
                    <input type="hidden" id="requestId" name="id">

                    <!-- Editable Product Info -->
                    <div class="mb-6 p-4 md:p-6 border rounded-lg bg-gray-50">
                        <h3 class="text-xl font-semibold mb-4 text-gray-700">Main Product Details</h3>
                        <p class="text-sm text-gray-600 mb-4">Review and edit the details for the main product being requested.</p>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-x-6 gap-y-4">
                            <div>
                                <label class="block text-gray-700 text-sm font-bold mb-1" for="editProductName">Product Name:</label>
                                <input class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" id="editProductName" name="ProductName" type="text" required>
                                <span id="editNameWarning" class="duplicate-warning hidden">Duplicate Name!</span>
                            </div>
                             <div>
                                <label class="block text-gray-700 text-sm font-bold mb-1" for="editProductBrand">Brand:</label>
                                <input class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" id="editProductBrand" name="ProductBrand" type="text">
                            </div>
                             <div>
                                <label class="block text-gray-700 text-sm font-bold mb-1" for="editProductCategory">Category:</label>
                                <input class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" id="editProductCategory" name="ProductCategory" type="text">
                            </div>
                             <div>
                                <label class="block text-gray-700 text-sm font-bold mb-1" for="editSubCategory">Sub Category:</label>
                                <input class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" id="editSubCategory" name="SubCategory" type="text">
                            </div>
                            <!-- Barcode Field with Scan Button -->
                            <div class="md:col-span-2">
                                <label class="block text-gray-700 text-sm font-bold mb-1" for="editBarcode">Barcode:</label>
                                <div class="input-with-button-wrapper">
                                    <input class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" id="editBarcode" name="Barcode" type="text">
                                    <button type="button" class="scan-barcode-btn bg-blue-500 hover:bg-blue-600 text-white font-semibold rounded focus:outline-none focus:shadow-outline flex-shrink-0" data-target="editBarcode">
                                        Scan
                                    </button>
                                </div>
                                <span id="editBarcodeWarning" class="duplicate-warning hidden">Duplicate Barcode!</span>
                            </div>
                            <div class="md:col-span-2">
                                <label class="block text-gray-700 text-sm font-bold mb-1" for="editMoreInfo">More Info / Description:</label>
                                 <textarea class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline h-24 resize-y" id="editMoreInfo" name="MoreInfo"></textarea>
                            </div>
                             <div class="md:col-span-2">
                                <label class="block text-gray-700 text-sm font-bold mb-1">Product Image:</label>
                                 <div class="image-input-container">
                                     <p class="text-sm text-gray-600 mb-3">Upload a new image file OR provide an image URL.</p>
                                     <div class="flex flex-col sm:flex-row items-start sm:items-center space-y-3 sm:space-y-0 sm:space-x-6">
                                         <div class="w-full sm:w-1/2">
                                             <label for="editProductImageFile" class="block text-sm text-gray-700 font-medium mb-1">Upload File:</label>
                                             <input type="file" id="editProductImageFile" accept="image/*" class="block w-full text-sm text-gray-500 file:mr-4 file:py-1.5 file:px-3 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-blue-50 file:text-blue-700 hover:file:bg-blue-100 cursor-pointer">
                                         </div>
                                         <div class="hidden sm:block text-gray-600 font-semibold">OR</div>
                                         <div class="w-full sm:w-1/2">
                                              <label for="editProductImageUrl" class="block text-sm text-gray-700 font-medium mb-1">Use Image URL:</label>
                                              <input type="text" id="editProductImageUrl" placeholder="https://example.com/image.jpg" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
                                         </div>
                                     </div>
                                     <input type="hidden" id="editProductImageBase64" name="ProductImage">
                                      <input type="hidden" id="editProductImageSource" name="ProductImageSource" value="none">
                                      <img id="editProductImagePreview" src="" alt="Product Image Preview" class="image-preview hidden">
                                 </div>
                            </div>
                        </div>
                    </div>

                    <!-- Alternative Product Info (for Products table) -->
                     <div class="mb-6 p-4 md:p-6 border rounded-lg bg-white">
                        <h3 class="text-xl font-semibold mb-4 text-gray-700">Alternative Products (Optional)</h3>
                        <p class="text-sm text-gray-600 mb-6">Add details for up to three alternative products.</p>

                         <!-- Alternative 1 -->
                         <div class="alternative-section">
                             <h4 class="font-semibold text-lg mb-3 text-gray-700">Alternative 1</h4>
                             <div class="grid grid-cols-1 md:grid-cols-2 gap-x-6 gap-y-4">
                                 <div>
                                     <label class="block text-gray-700 text-sm font-bold mb-1" for="altName1">Name:</label>
                                     <input class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" id="altName1" name="AlternativeName1" type="text">
                                 </div>
                                 <div>
                                     <label class="block text-gray-700 text-sm font-bold mb-1" for="altBrand1">Brand:</label>
                                     <input class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" id="altBrand1" name="AlternativeBrand1" type="text">
                                 </div>
                                  <!-- Alt 1 Barcode -->
                                  <div class="md:col-span-2">
                                     <label class="block text-gray-700 text-sm font-bold mb-1" for="altBarcode1">Barcode:</label>
                                     <div class="input-with-button-wrapper">
                                        <input class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" id="altBarcode1" name="AlternativeBarcode1" type="text">
                                        <button type="button" class="scan-barcode-btn bg-blue-500 hover:bg-blue-600 text-white font-semibold rounded focus:outline-none focus:shadow-outline flex-shrink-0" data-target="altBarcode1">
                                            Scan
                                        </button>
                                     </div>
                                  </div>
                                  <div class="md:col-span-2">
                                     <label class="block text-gray-700 text-sm font-bold mb-1">Image:</label>
                                      <div class="image-input-container">
                                          <p class="text-sm text-gray-600 mb-3">Upload image file OR provide URL.</p>
                                          <div class="flex flex-col sm:flex-row items-start sm:items-center space-y-3 sm:space-y-0 sm:space-x-6">
                                              <div class="w-full sm:w-1/2">
                                                  <label for="altImageFile1" class="block text-sm text-gray-700 font-medium mb-1">Upload File:</label>
                                                   <input type="file" id="altImageFile1" accept="image/*" class="block w-full text-sm text-gray-500 file:mr-4 file:py-1.5 file:px-3 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-blue-50 file:text-blue-700 hover:file:bg-blue-100 cursor-pointer">
                                              </div>
                                              <div class="hidden sm:block text-gray-600 font-semibold">OR</div>
                                              <div class="w-full sm:w-1/2">
                                                  <label for="altImageUrl1" class="block text-sm text-gray-700 font-medium mb-1">Use Image URL:</label>
                                                  <input type="text" id="altImageUrl1" placeholder="https://example.com/alt1.jpg" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
                                              </div>
                                          </div>
                                           <input type="hidden" id="altImageBase64_1" name="AlternativeImage1">
                                           <input type="hidden" id="altImageSource_1" name="AlternativeImageSource1" value="none">
                                          <img id="altImagePreview1" src="" alt="Alt 1 Image Preview" class="image-preview hidden">
                                      </div>
                                  </div>
                             </div>
                         </div>

                          <!-- Alternative 2 -->
                         <div class="alternative-section">
                             <h4 class="font-semibold text-lg mb-3 text-gray-700">Alternative 2</h4>
                             <div class="grid grid-cols-1 md:grid-cols-2 gap-x-6 gap-y-4">
                                 <div>
                                     <label class="block text-gray-700 text-sm font-bold mb-1" for="altName2">Name:</label>
                                     <input class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" id="altName2" name="AlternativeName2" type="text">
                                 </div>
                                 <div>
                                     <label class="block text-gray-700 text-sm font-bold mb-1" for="altBrand2">Brand:</label>
                                     <input class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" id="altBrand2" name="AlternativeBrand2" type="text">
                                 </div>
                                  <!-- Alt 2 Barcode -->
                                  <div class="md:col-span-2">
                                     <label class="block text-gray-700 text-sm font-bold mb-1" for="altBarcode2">Barcode:</label>
                                     <div class="input-with-button-wrapper">
                                        <input class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" id="altBarcode2" name="AlternativeBarcode2" type="text">
                                         <button type="button" class="scan-barcode-btn bg-blue-500 hover:bg-blue-600 text-white font-semibold rounded focus:outline-none focus:shadow-outline flex-shrink-0" data-target="altBarcode2">
                                            Scan
                                        </button>
                                     </div>
                                  </div>
                                 <div class="md:col-span-2">
                                     <label class="block text-gray-700 text-sm font-bold mb-1">Image:</label>
                                      <div class="image-input-container">
                                           <p class="text-sm text-gray-600 mb-3">Upload image file OR provide URL.</p>
                                          <div class="flex flex-col sm:flex-row items-start sm:items-center space-y-3 sm:space-y-0 sm:space-x-6">
                                               <div class="w-full sm:w-1/2">
                                                  <label for="altImageFile2" class="block text-sm text-gray-700 font-medium mb-1">Upload File:</label>
                                                  <input type="file" id="altImageFile2" accept="image/*" class="block w-full text-sm text-gray-500 file:mr-4 file:py-1.5 file:px-3 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-blue-50 file:text-blue-700 hover:file:bg-blue-100 cursor-pointer">
                                              </div>
                                               <div class="hidden sm:block text-gray-600 font-semibold">OR</div>
                                              <div class="w-full sm:w-1/2">
                                                  <label for="altImageUrl2" class="block text-sm text-gray-700 font-medium mb-1">Use Image URL:</label>
                                                  <input type="text" id="altImageUrl2" placeholder="https://example.com/alt2.jpg" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
                                              </div>
                                          </div>
                                            <input type="hidden" id="altImageBase64_2" name="AlternativeImage2">
                                            <input type="hidden" id="altImageSource_2" name="AlternativeImageSource2" value="none">
                                            <img id="altImagePreview2" src="" alt="Alt 2 Image Preview" class="image-preview hidden">
                                      </div>
                                 </div>
                             </div>
                         </div>

                          <!-- Alternative 3 -->
                         <div class="alternative-section">
                             <h4 class="font-semibold text-lg mb-3 text-gray-700">Alternative 3</h4>
                             <div class="grid grid-cols-1 md:grid-cols-2 gap-x-6 gap-y-4">
                                 <div>
                                     <label class="block text-gray-700 text-sm font-bold mb-1" for="altName3">Name:</label>
                                     <input class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" id="altName3" name="AlternativeName3" type="text">
                                 </div>
                                 <div>
                                     <label class="block text-gray-700 text-sm font-bold mb-1" for="altBrand3">Brand:</label>
                                     <input class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" id="altBrand3" name="AlternativeBrand3" type="text">
                                 </div>
                                 <!-- Alt 3 Barcode -->
                                 <div class="md:col-span-2">
                                     <label class="block text-gray-700 text-sm font-bold mb-1" for="altBarcode3">Barcode:</label>
                                     <div class="input-with-button-wrapper">
                                        <input class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" id="altBarcode3" name="AlternativeBarcode3" type="text">
                                         <button type="button" class="scan-barcode-btn bg-blue-500 hover:bg-blue-600 text-white font-semibold rounded focus:outline-none focus:shadow-outline flex-shrink-0" data-target="altBarcode3">
                                            Scan
                                        </button>
                                     </div>
                                 </div>
                                  <div class="md:col-span-2">
                                     <label class="block text-gray-700 text-sm font-bold mb-1">Image:</label>
                                       <div class="image-input-container">
                                           <p class="text-sm text-gray-600 mb-3">Upload image file OR provide URL.</p>
                                           <div class="flex flex-col sm:flex-row items-start sm:items-center space-y-3 sm:space-y-0 sm:space-x-6">
                                                <div class="w-full sm:w-1/2">
                                                   <label for="altImageFile3" class="block text-sm text-gray-700 font-medium mb-1">Upload File:</label>
                                                   <input type="file" id="altImageFile3" accept="image/*" class="block w-full text-sm text-gray-500 file:mr-4 file:py-1.5 file:px-3 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-blue-50 file:text-blue-700 hover:file:bg-blue-100 cursor-pointer">
                                               </div>
                                                <div class="hidden sm:block text-gray-600 font-semibold">OR</div>
                                               <div class="w-full sm:w-1/2">
                                                   <label for="altImageUrl3" class="block text-sm text-gray-700 font-medium mb-1">Use Image URL:</label>
                                                   <input type="text" id="altImageUrl3" placeholder="https://example.com/alt3.jpg" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
                                               </div>
                                           </div>
                                            <input type="hidden" id="altImageBase64_3" name="AlternativeImage3">
                                            <input type="hidden" id="altImageSource_3" name="AlternativeImageSource3" value="none">
                                            <img id="altImagePreview3" src="" alt="Alt 3 Image Preview" class="image-preview hidden">
                                       </div>
                                  </div>
                             </div>
                         </div>
                     </div>


                    <div class="flex flex-col sm:flex-row items-center justify-end mt-6 space-y-3 sm:space-y-0 sm:space-x-4">
                         <button id="rejectBtn" class="delete-button action-button w-full sm:w-auto" type="button">
                            Reject Request
                            <span id="rejectSpinner" class="spinner hidden"></span>
                        </button>
                        <button id="approveBtn" class="add-button action-button w-full sm:w-auto" type="submit">
                            Approve & Add to Products
                             <span id="approveSpinner" class="spinner hidden"></span>
                        </button>
                    </div>
                     <p id="reviewFormMessage" class="form-message"></p>
                </form>
            </div>
        </div>

         <!-- The Add Product Modal -->
         <div id="addProductModal" class="modal">
            <!-- Modal content -->
            <div class="modal-content">
                <span class="close-button close-add-modal">×</span>
                <h2 class="text-2xl font-bold mb-6 text-gray-800">Add New Product Directly</h2>

                <form id="addProductForm">
                    <!-- Product Info (will go to Products table) - Similar fields as review form -->
                    <div class="mb-6 p-4 md:p-6 border rounded-lg bg-gray-50">
                        <h3 class="text-xl font-semibold mb-4 text-gray-700">Main Product Details</h3>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-x-6 gap-y-4">
                            <div>
                                <label class="block text-gray-700 text-sm font-bold mb-1" for="addProductName">Product Name:</label>
                                <input class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" id="addProductName" name="ProductName" type="text" required>
                                <span id="addNameWarning" class="duplicate-warning hidden">Duplicate Name!</span>
                            </div>
                             <div>
                                <label class="block text-gray-700 text-sm font-bold mb-1" for="addProductBrand">Brand:</label>
                                <input class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" id="addProductBrand" name="ProductBrand" type="text">
                            </div>
                             <div>
                                <label class="block text-gray-700 text-sm font-bold mb-1" for="addProductCategory">Category:</label>
                                <input class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" id="addProductCategory" name="ProductCategory" type="text">
                            </div>
                             <div>
                                <label class="block text-gray-700 text-sm font-bold mb-1" for="addSubCategory">Sub Category:</label>
                                <input class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" id="addSubCategory" name="SubCategory" type="text">
                            </div>
                            <!-- Add Product Barcode -->
                            <div class="md:col-span-2">
                                <label class="block text-gray-700 text-sm font-bold mb-1" for="addBarcode">Barcode:</label>
                                <div class="input-with-button-wrapper">
                                    <input class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" id="addBarcode" name="Barcode" type="text">
                                    <button type="button" class="scan-barcode-btn bg-blue-500 hover:bg-blue-600 text-white font-semibold rounded focus:outline-none focus:shadow-outline flex-shrink-0" data-target="addBarcode">
                                        Scan
                                    </button>
                                </div>
                                <span id="addBarcodeWarning" class="duplicate-warning hidden">Duplicate Barcode!</span>
                            </div>
                            <div class="md:col-span-2">
                                <label class="block text-gray-700 text-sm font-bold mb-1" for="addMoreInfo">More Info / Description:</label>
                                 <textarea class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline h-24 resize-y" id="addMoreInfo" name="MoreInfo"></textarea>
                            </div>
                             <div class="md:col-span-2">
                                <label class="block text-gray-700 text-sm font-bold mb-1">Product Image:</label>
                                 <div class="image-input-container">
                                     <p class="text-sm text-gray-600 mb-3">Upload an image file OR provide an image URL.</p>
                                     <div class="flex flex-col sm:flex-row items-start sm:items-center space-y-3 sm:space-y-0 sm:space-x-6">
                                         <div class="w-full sm:w-1/2">
                                             <label for="addProductImageFile" class="block text-sm text-gray-700 font-medium mb-1">Upload File:</label>
                                             <input type="file" id="addProductImageFile" accept="image/*" class="block w-full text-sm text-gray-500 file:mr-4 file:py-1.5 file:px-3 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-blue-50 file:text-blue-700 hover:file:bg-blue-100 cursor-pointer">
                                         </div>
                                         <div class="hidden sm:block text-gray-600 font-semibold">OR</div>
                                         <div class="w-full sm:w-1/2">
                                              <label for="addProductImageUrl" class="block text-sm text-gray-700 font-medium mb-1">Use Image URL:</label>
                                              <input type="text" id="addProductImageUrl" placeholder="https://example.com/image.jpg" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
                                         </div>
                                     </div>
                                     <input type="hidden" id="addProductImageBase64" name="ProductImage">
                                      <input type="hidden" id="addProductImageSource" name="ProductImageSource" value="none">
                                      <img id="addProductImagePreview" src="" alt="Product Image Preview" class="image-preview hidden">
                                 </div>
                            </div>
                        </div>
                    </div>

                    <!-- Alternative Product Info (for Products table) - Similar fields -->
                     <div class="mb-6 p-4 md:p-6 border rounded-lg bg-white">
                        <h3 class="text-xl font-semibold mb-4 text-gray-700">Alternative Products (Optional)</h3>
                        <p class="text-sm text-gray-600 mb-6">Add details for up to three alternative products.</p>

                         <!-- Alternative 1 (Add Modal) -->
                         <div class="alternative-section">
                             <h4 class="font-semibold text-lg mb-3 text-gray-700">Alternative 1</h4>
                             <div class="grid grid-cols-1 md:grid-cols-2 gap-x-6 gap-y-4">
                                 <div>
                                     <label class="block text-gray-700 text-sm font-bold mb-1" for="addAltName1">Name:</label>
                                     <input class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" id="addAltName1" name="AlternativeName1" type="text">
                                 </div>
                                 <div>
                                     <label class="block text-gray-700 text-sm font-bold mb-1" for="addAltBrand1">Brand:</label>
                                     <input class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" id="addAltBrand1" name="AlternativeBrand1" type="text">
                                 </div>
                                  <!-- Alt 1 Barcode (Add Modal) -->
                                  <div class="md:col-span-2">
                                     <label class="block text-gray-700 text-sm font-bold mb-1" for="addAltBarcode1">Barcode:</label>
                                     <div class="input-with-button-wrapper">
                                        <input class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" id="addAltBarcode1" name="AlternativeBarcode1" type="text">
                                        <button type="button" class="scan-barcode-btn bg-blue-500 hover:bg-blue-600 text-white font-semibold rounded focus:outline-none focus:shadow-outline flex-shrink-0" data-target="addAltBarcode1">
                                            Scan
                                        </button>
                                     </div>
                                  </div>
                                  <div class="md:col-span-2">
                                     <label class="block text-gray-700 text-sm font-bold mb-1">Image:</label>
                                      <div class="image-input-container">
                                          <p class="text-sm text-gray-600 mb-3">Upload image file OR provide URL.</p>
                                          <div class="flex flex-col sm:flex-row items-start sm:items-center space-y-3 sm:space-y-0 sm:space-x-6">
                                               <div class="w-full sm:w-1/2">
                                                  <label for="addAltImageFile1" class="block text-sm text-gray-700 font-medium mb-1">Upload File:</label>
                                                  <input type="file" id="addAltImageFile1" accept="image/*" class="block w-full text-sm text-gray-500 file:mr-4 file:py-1.5 file:px-3 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-blue-50 file:text-blue-700 hover:file:bg-blue-100 cursor-pointer">
                                              </div>
                                               <div class="hidden sm:block text-gray-600 font-semibold">OR</div>
                                              <div class="w-full sm:w-1/2">
                                                  <label for="addAltImageUrl1" class="block text-sm text-gray-700 font-medium mb-1">Use Image URL:</label>
                                                  <input type="text" id="addAltImageUrl1" placeholder="https://example.com/alt1.jpg" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
                                              </div>
                                          </div>
                                           <input type="hidden" id="addAltImageBase64_1" name="AlternativeImage1">
                                           <input type="hidden" id="addAltImageSource_1" name="AlternativeImageSource1" value="none">
                                          <img id="addAltImagePreview1" src="" alt="Alt 1 Image Preview" class="image-preview hidden">
                                      </div>
                                  </div>
                             </div>
                         </div>

                          <!-- Alternative 2 (Add Modal) -->
                         <div class="alternative-section">
                             <h4 class="font-semibold text-lg mb-3 text-gray-700">Alternative 2</h4>
                             <div class="grid grid-cols-1 md:grid-cols-2 gap-x-6 gap-y-4">
                                 <div>
                                     <label class="block text-gray-700 text-sm font-bold mb-1" for="addAltName2">Name:</label>
                                     <input class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" id="addAltName2" name="AlternativeName2" type="text">
                                 </div>
                                 <div>
                                     <label class="block text-gray-700 text-sm font-bold mb-1" for="addAltBrand2">Brand:</label>
                                     <input class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" id="addAltBrand2" name="AlternativeBrand2" type="text">
                                 </div>
                                  <!-- Alt 2 Barcode (Add Modal) -->
                                  <div class="md:col-span-2">
                                     <label class="block text-gray-700 text-sm font-bold mb-1" for="addAltBarcode2">Barcode:</label>
                                      <div class="input-with-button-wrapper">
                                        <input class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" id="addAltBarcode2" name="AlternativeBarcode2" type="text">
                                         <button type="button" class="scan-barcode-btn bg-blue-500 hover:bg-blue-600 text-white font-semibold rounded focus:outline-none focus:shadow-outline flex-shrink-0" data-target="addAltBarcode2">
                                            Scan
                                        </button>
                                     </div>
                                  </div>
                                 <div class="md:col-span-2">
                                     <label class="block text-gray-700 text-sm font-bold mb-1">Image:</label>
                                      <div class="image-input-container">
                                           <p class="text-sm text-gray-600 mb-3">Upload image file OR provide URL.</p>
                                          <div class="flex flex-col sm:flex-row items-start sm:items-center space-y-3 sm:space-y-0 sm:space-x-6">
                                               <div class="w-full sm:w-1/2">
                                                  <label for="addAltImageFile2" class="block text-sm text-gray-700 font-medium mb-1">Upload File:</label>
                                                  <input type="file" id="addAltImageFile2" accept="image/*" class="block w-full text-sm text-gray-500 file:mr-4 file:py-1.5 file:px-3 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-blue-50 file:text-blue-700 hover:file:bg-blue-100 cursor-pointer">
                                              </div>
                                               <div class="hidden sm:block text-gray-600 font-semibold">OR</div>
                                              <div class="w-full sm:w-1/2">
                                                  <label for="addAltImageUrl2" class="block text-sm text-gray-700 font-medium mb-1">Use Image URL:</label>
                                                  <input type="text" id="addAltImageUrl2" placeholder="https://example.com/alt2.jpg" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
                                              </div>
                                          </div>
                                        <input type="hidden" id="addAltImageBase64_2" name="AlternativeImage2">
                                        <input type="hidden" id="addAltImageSource_2" name="AlternativeImageSource2" value="none">
                                        <img id="addAltImagePreview2" src="" alt="Alt 2 Image Preview" class="image-preview hidden">
                                  </div>
                             </div>
                         </div>
                     </div>

                      <!-- Alternative 3 (Add Modal) -->
                     <div class="alternative-section">
                         <h4 class="font-semibold text-lg mb-3 text-gray-700">Alternative 3</h4>
                         <div class="grid grid-cols-1 md:grid-cols-2 gap-x-6 gap-y-4">
                             <div>
                                 <label class="block text-gray-700 text-sm font-bold mb-1" for="addAltName3">Name:</label>
                                 <input class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" id="addAltName3" name="AlternativeName3" type="text">
                             </div>
                             <div>
                                 <label class="block text-gray-700 text-sm font-bold mb-1" for="addAltBrand3">Brand:</label>
                                 <input class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" id="addAltBrand3" name="AlternativeBrand3" type="text">
                             </div>
                             <!-- Alt 3 Barcode (Add Modal) -->
                             <div class="md:col-span-2">
                                 <label class="block text-gray-700 text-sm font-bold mb-1" for="addAltBarcode3">Barcode:</label>
                                 <div class="input-with-button-wrapper">
                                    <input class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" id="addAltBarcode3" name="AlternativeBarcode3" type="text">
                                     <button type="button" class="scan-barcode-btn bg-blue-500 hover:bg-blue-600 text-white font-semibold rounded focus:outline-none focus:shadow-outline flex-shrink-0" data-target="addAltBarcode3">
                                        Scan
                                    </button>
                                 </div>
                             </div>
                              <div class="md:col-span-2">
                                 <label class="block text-gray-700 text-sm font-bold mb-1">Image:</label>
                                   <div class="image-input-container">
                                       <p class="text-sm text-gray-600 mb-3">Upload image file OR provide URL.</p>
                                       <div class="flex flex-col sm:flex-row items-start sm:items-center space-y-3 sm:space-y-0 sm:space-x-6">
                                            <div class="w-full sm:w-1/2">
                                               <label for="addAltImageFile3" class="block text-sm text-gray-700 font-medium mb-1">Upload File:</label>
                                               <input type="file" id="addAltImageFile3" accept="image/*" class="block w-full text-sm text-gray-500 file:mr-4 file:py-1.5 file:px-3 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-blue-50 file:text-blue-700 hover:file:bg-blue-100 cursor-pointer">
                                           </div>
                                            <div class="hidden sm:block text-gray-600 font-semibold">OR</div>
                                           <div class="w-full sm:w-1/2">
                                               <label for="addAltImageUrl3" class="block text-sm text-gray-700 font-medium mb-1">Use Image URL:</label>
                                               <input type="text" id="addAltImageUrl3" placeholder="https://example.com/alt3.jpg" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
                                           </div>
                                       </div>
                                        <input type="hidden" id="addAltImageBase64_3" name="AlternativeImage3">
                                        <input type="hidden" id="addAltImageSource_3" name="AlternativeImageSource3" value="none">
                                        <img id="addAltImagePreview3" src="" alt="Alt 3 Image Preview" class="image-preview hidden">
                                   </div>
                              </div>
                         </div>
                     </div>
                 </div>


                <div class="flex justify-end mt-6">
                     <button id="saveProductBtn" class="add-button action-button" type="submit">
                         Save Product
                         <span id="saveProductSpinner" class="spinner hidden"></span>
                     </button>
                </div>
                <p id="addProductFormMessage" class="form-message"></p>
            </form>
        </div>
    </div>

    <!-- Barcode Scanner Modal -->
    <div id="scannerModal" class="modal">
        <div class="modal-content"> <!-- Scanner modal uses specific width -->
            <span id="closeScannerBtn" class="close-button">×</span>
            <h2 class="text-xl font-bold mb-4 text-gray-800">Scan Barcode</h2>
            <div class="relative">
                <video id="scannerVideo" playsinline></video> <!-- playsinline recommended for mobile -->
                 <!-- Target area overlay -->
                 <div class="absolute inset-0 pointer-events-none">
                    <div></div> <!-- This div is styled via CSS -->
                </div>
            </div>
            <p id="scannerMessage" class="text-center mt-3 text-sm text-gray-600">Requesting camera...</p>
            <!-- Optional: Camera selection dropdown
            <div class="mt-3">
                <label for="cameraSelect" class="block text-sm font-medium text-gray-700">Camera:</label>
                <select id="cameraSelect" class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm rounded-md">
                </select>
            </div> -->
        </div>
    </div>


    <!-- Add ZXing Library -->
    <script src="https://cdn.jsdelivr.net/npm/@zxing/library/umd/index.min.js"></script>

    <!-- Load custom JavaScript modules -->
    <script type="module" src="js/helpers.js"></script>
    <script type="module" src="js/ui.js"></script>
    <script type="module" src="js/api.js"></script>
    <script type="module" src="js/scanner.js"></script>
    <script type="module" src="js/script.js"></script>


    </body>
    </html>
