    <?php
    // includes/db.php
    require_once __DIR__ . '/config.php'; // config.php ফাইলটি include করুন

    $conn = null;

    try {
        $conn = new PDO("mysql:host=$host;dbname=$dbName", $userName, $pass);
        $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION); // PDO Exception মোড চালু
        $conn->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC); // ফলাফল Associative Array হিসাবে Fetch করা
    } catch (PDOException $e) {
        // সিকিউরিটির জন্য প্রোডাকশনে বিস্তারিত ত্রুটি দেখানো উচিত নয়
        error_log("Database connection error: " . $e->getMessage()); // সার্ভার লগ ফাইলে ত্রুটি লিখুন
        // ক্লায়েন্টকে একটি জেনেরিক ত্রুটি বার্তা পাঠান
        echo json_encode(['success' => false, 'message' => 'Database connection failed.']);
        exit; // ডাটাবেস সংযোগ ব্যর্থ হলে স্ক্রিপ্ট বন্ধ করুন
    }

    // সংযোগ সফল হলে $conn ভেরিয়েবল উপলব্ধ থাকবে
    ?>