    <?php
    // includes/auth.php

    // সেশন স্টার্ট করুন যদি আগে থেকে স্টার্ট না হয়ে থাকে
    if (session_status() == PHP_SESSION_NONE) {
        session_start();
    }

    // অথেন্টিকেশন চেক করুন
    function isAuthenticated() {
        return isset($_SESSION['loggedin']) && $_SESSION['loggedin'] === true;
    }

    // প্রোটেক্টেড অ্যাকশনের জন্য অথেন্টিকেশন নিশ্চিত করুন
    function requireAuth() {
        if (!isAuthenticated()) {
            // JSON রেসপন্স পাঠান যেহেতু এটি API
            header('Content-Type: application/json');
            echo json_encode(['success' => false, 'message' => 'Authentication required. Please log in.']);
            exit; // অ্যাক্সেস denied হলে স্ক্রিপ্ট বন্ধ করুন
        }
    }

    // লগইন হ্যান্ডেল করুন
    function handleLogin($conn, $username, $password) {
         // ইনপুট স্যানিটাইজেশন
         $username = filter_var(trim($username), FILTER_SANITIZE_STRING);
         $password = trim($password); // পাসওয়ার্ড hash করার আগে trim করা যেতে পারে

        if (empty($username) || empty($password)) {
            return ['success' => false, 'message' => 'Username and password are required.'];
        }

        try {
            // MetaData টেবিল থেকে অ্যাডমিন ক্রেডেনশিয়াল Fetch করুন
            $stmt = $conn->prepare("SELECT meta_key, meta_value FROM MetaData WHERE meta_key IN ('AdminUsername', 'AdminPass')");
            $stmt->execute();
            $metadata = $stmt->fetchAll(PDO::FETCH_KEY_PAIR);

            $storedUsername = $metadata['AdminUsername'] ?? null;
            $storedHash = $metadata['AdminPass'] ?? null;

            // ক্রেডেনশিয়াল ভেরিফাই করুন
            // strcmp ব্যবহার করা ভাল, যদিও === স্ট্রিং তুলনা করবে
            if ($storedUsername && $storedHash && strcmp($username, $storedUsername) === 0 && password_verify($password, $storedHash)) {
                // লগইন সফল
                // সেশন ফিক্সেশন প্রতিরোধ করার জন্য সেশন ID regenerate করুন
                session_regenerate_id(true);
                $_SESSION['loggedin'] = true;
                $_SESSION['username'] = $username; // সেশনে ইউজারনেম স্টোর করা

                return ['success' => true, 'message' => 'Login successful.'];
            } else {
                // লগইন ব্যর্থ
                // সিকিউরিটির জন্য জেনেরিক বার্তা ব্যবহার করুন
                return ['success' => false, 'message' => 'Invalid username or password.'];
            }

        } catch (PDOException $e) {
            error_log("Database error during login: " . $e->getMessage());
            return ['success' => false, 'message' => 'Error during login process.'];
        }
    }

    // লগআউট হ্যান্ডেল করুন
    function handleLogout() {
        // সেশনের সমস্ত ভেরিয়েবল আনসেট করুন
        $_SESSION = array();

        // সেশন কুকি ডিলিট করুন
        if (ini_get("session.use_cookies")) {
            $params = session_get_cookie_params();
            setcookie(session_name(), '', time() - 42000,
                $params["path"], $params["domain"],
                $params["secure"], $params["httponly"]
            );
        }

        // সেশন ডেস্ট্রয় করুন
        session_destroy();

        return ['success' => true, 'message' => 'Logged out successfully.'];
    }

    // check_auth অ্যাকশন হ্যান্ডেল করুন
    function handleCheckAuth() {
        if (isAuthenticated()) {
            return ['success' => true, 'message' => 'Authenticated.'];
        } else {
            return ['success' => false, 'message' => 'Not authenticated.'];
        }
    }

    ?>